"""
HB_BrushStrengthIncrease V1.1

Last Modified: Oct/01/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_BrushStrengthIncrease
Description-US: Increase the strength of Tools and Objects

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=34m5s

Usage:
This Script works with several Tools and Objects to increase the Tool-Strength


ChangeLog:
Jun/11/2015 V1.0
- Release Version

Oct/01/2018 V1.1
- Python Rewrite
- Code Optimization
- New Highres Icon

"""

import c4d
from c4d import documents, plugins
  

def tool():
        return plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)
    

def main():
    
    PlusFactor=1.2
    SelObj=doc.GetActiveObject()
    Tool_ID=doc.GetAction()

            
    
    #BrushTool
    if Tool_ID==1016202:
 
        tool()[c4d.MDATA_BRUSH_FALLOFF_STRENGTH]=tool()[c4d.MDATA_BRUSH_FALLOFF_STRENGTH]*PlusFactor
    

    
    #SoftSelection
    if Tool_ID==200000088 or Tool_ID==200000089 or Tool_ID==200000090 :

        if tool()[c4d.MDATA_SOFT_ENABLE]:
       
            tool()[c4d.MDATA_SOFT_STRENGTH]=float(tool()[c4d.MDATA_SOFT_STRENGTH])*PlusFactor
        
    #MagnetTool
    if Tool_ID==1016185:
        tool()[c4d.MDATA_MAGNET_FALLOFF_STRENGTH]=tool()[c4d.MDATA_MAGNET_FALLOFF_STRENGTH]*PlusFactor
    
    
    #PaintTool
    if Tool_ID==1021286:
        tool()[c4d.ID_CA_PAINT_TOOL_OPACITY]=tool()[c4d.ID_CA_PAINT_TOOL_OPACITY]*PlusFactor

    

    #WeightTool
    if Tool_ID==1019499:
        tool()[c4d.ID_CA_WEIGHT_TOOL_STRENGTH]=tool()[c4d.ID_CA_WEIGHT_TOOL_STRENGTH]*PlusFactor
        
    #DoodleTool
    if Tool_ID==1022257:
  
        tool()[c4d.MDATA_DOODLE_OPACITY]=tool()[c4d.MDATA_DOODLE_OPACITY]*PlusFactor
    

    #DoodleEraser
    if Tool_ID==1022286:
        tool()[c4d.MDATA_DOODLE_OPACITY]=tool()[c4d.MDATA_DOODLE_OPACITY]*PlusFactor        
    

   
        

if __name__=='__main__':
    main()
    c4d.EventAdd()
